要想更好了解socket编程，有一个不可绕过的环节就是IO．
在Linux中，一切皆文件．实际上要文件干啥？不就是读写么？所以，这句话本质就是"IO才是王道"．用php的fopen打开文件关闭文件读读写写，这叫本地文件IO．在socket编程中，本质就是网络IO．
所以，在开始进一步的socket编程前，我们必须先从概念上认识好IO．
如果到这里你还对IO没啥概念，那么我就通过几个词来给你一个大概的印象：同步，异步，阻塞，非阻塞，甚至是同步阻塞，同步非阻塞，异步阻塞，异步非阻塞．是不是晕了？截至到目前为止，你可以简单地认为只要搞明白这几个名词的含义以及区别，就算弄明白IO了，至少了可以继续往下看了．
先机械记忆一波儿：IO分为两大种，同步和异步．
###### 同步IO：
- 阻塞IO
- 非阻塞IO 
- IO多路复用（包括select，poll，epoll三种）
- 信号驱动IO

###### 异步IO
那么如何理解区别这几个概念呢？尤其是同步和阻塞，异步和非阻塞，看起来就是一样的．
我先举个例子结合自己的理解来说明一下：
1. 你去甜在心馒头店买太极馒头，阿梅说：＂暂时没，正在蒸呢，你自己看着点儿！＂．于是你就站在旁边只等馒头．此时的你，**是阻塞的**，**是同步的**．阻塞表现在你除了等馒头，别的什么都不做了．同步表现在等馒头的过程中，阿梅不提供通知服务，你不得不自己要等到＂馒头出炉＂的消息．
2. 你去甜在心馒头店买太极馒头，阿梅说：＂暂时没，正在蒸呢，你自己看着点儿！＂．于是你就站在旁边发微信，然后问一句：＂好了没？＂，然后发QQ，然后再问一句：＂好了没？＂．此时的你，**是非阻塞的**，**是同步的**．非阻塞表现在你除了等馒头，自己还干干别的时不时会主动问问馒头好没好．同步表现在等馒头的过程中，阿梅不提供通知服务，你不得不自己要等到＂馒头出炉＂的消息．
3. 你去甜在心馒头店买太极馒头，阿梅说：＂暂时没，正在蒸呢，蒸好了我打电话告诉你！＂．但你依然站在旁边只等馒头，此时的你，**是阻塞的**，**是异步的**．阻塞表现在你除了等馒头，别的什么都不做了．异步表现在等馒头的过程中，阿梅提供电话通知＂馒头出炉＂的消息，你只需要等阿梅的电话．
4. 你去甜在心馒头店买太极馒头，阿梅说：＂暂时没，正在蒸呢，蒸好了我打电话告诉你！＂．于是你就走了，去买了双新球鞋，看了看武馆，总之，从此不再过问馒头的事情，一心只等阿梅电话．此时的你，**是非阻塞的**，**是异步的**．非阻塞表现在你除了等馒头，自己还干干别的时不时会主动问问馒头好没好．异步表现在等馒头的过程中，阿梅提供电话通知＂馒头出炉＂的消息，你只需要等阿梅的电话．

如果你仔细品过上面案例中的每一个字，你就能慢慢体会到之所以异步和非阻塞，同步和阻塞容易混淆，仅仅是因为二者的表现形式稍微有点儿相似而已．
阻塞和非阻塞关注的是：在等馒头的过程中，你在干啥．
同步和异步关注的是：等馒头这件事，你是一直等到＂馒头出炉＂的结果，还是立即跑路等阿梅告诉你的＂馒头出炉＂．重点的是你是如何得知＂馒头出炉＂的．
所以现实世界中，最傻的人才会采用异步阻塞的IO方式去写程序．其余三种方式，更多的人都会选择同步阻塞或者异步非阻塞．同步非阻塞最大的问题在于，你需要不断在各个任务中忙碌着，导致你的大脑混乱，非常累．
